<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Common;

use Erlage\Photogram\Data\Dtos\AbstractDTO;

abstract class AbstractDisplayUserTagDTO extends AbstractDTO
{
    /*
    |--------------------------------------------------------------------------
    | private key map, warning! must not change
    |--------------------------------------------------------------------------
    */

    const KEY_USER_ID = 'user_id';

    const KEY_USERNAME = 'username';

    const KEY_OFFSET_TOP = 'offset_top';

    const KEY_OFFSET_LEFT = 'offset_left';

    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string
     */
    private $userId;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $offsetTop;

    /**
     * @var string
     */
    private $offsetLeft;

    /*
    |--------------------------------------------------------------------------
    | getters
    |--------------------------------------------------------------------------
    */

    public function getUserId(): string
    {
        return $this -> userId;
    }

    public function getUsername(): string
    {
        return $this -> username;
    }

    public function getOffsetTop(): string
    {
        return $this -> offsetTop;
    }

    public function getOffsetLeft(): string
    {
        return $this -> offsetLeft;
    }

    /*
    |--------------------------------------------------------------------------
    | setters
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public function setUserId(string $userId)
    {
        $this -> userId = $userId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setUsername(string $username)
    {
        $this -> username = $username;

        return $this;
    }

    /**
     * @return static 
     */
    public function setOffsetTop(string $offsetTop)
    {
        $this -> offsetTop = $offsetTop;

        return $this;
    }

    /**
     * @return static 
     */
    public function setOffsetLeft(string $offsetLeft)
    {
        $this -> offsetLeft = $offsetLeft;

        return $this;
    }

    /*
    |--------------------------------------------------------------------------
    | from json
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public static function fromJsonMap(array $data)
    {
        return (new static())
            -> setUserId((string) $data[self::KEY_USER_ID])
            -> setUsername((string) $data[self::KEY_USERNAME])
            -> setOffsetTop((string) $data[self::KEY_OFFSET_TOP])
            -> setOffsetLeft((string) $data[self::KEY_OFFSET_LEFT]);
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return array(
            self::KEY_USER_ID     => $this -> userId,
            self::KEY_USERNAME    => $this -> username,
            self::KEY_OFFSET_TOP  => $this -> offsetTop,
            self::KEY_OFFSET_LEFT => $this -> offsetLeft,
        );
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    public static function serialize($displayUserTagDTO): string
    {
        return \json_encode($displayUserTagDTO);
    }

    /**
     * @return static 
     */
    public static function deSerialize(string $displayUserTagDTO)
    {
        $data = \json_decode($displayUserTagDTO, true);

        return static::fromJsonMap($data);
    }
}
